/********************************************************************
*																	*
*      				 Auto Generated File                            *
*                     												*		
*********************************************************************/

/** include files **/
#include "Timecostcalculator.h"           // base header
#include "message.h"       // InternalMessage ....
#include "distri.h"        // class Distribution
#include "mainsimu.h"      // class MainSimulator
#include "strutil.h"       // str2float( ... )


/*******************************************************************
* Function Name: Timecostcalculator
* Description: constructor
********************************************************************/
Timecostcalculator::Timecostcalculator( const string &name )
: Atomic( name )
, totalreqtime( addInputPort( "totalreqtime" ) )
, totaldesigntime( addInputPort( "totaldesigntime" ) )
, totalimptime( addInputPort( "totalimptime" ) )
, totaltime( addOutputPort( "totaltime" ) )
, projectcost( addOutputPort( "projectcost" ) )
, preparationTime( 0, 0, 0, 0 )
{
	string time( MainSimulator::Instance().getParameter( description(), "preparation" ) ) ;

	if( time != "" )
		preparationTime = time ;

}

/*******************************************************************
* Function Name: initFunction
********************************************************************/
Model &Timecostcalculator::initFunction()
{
	// [(!) Initialize common variables]
	this->elapsed = Time::Zero;
 	this->timeLeft = Time::Inf;
 	// this->sigma = Time::Inf; // stays in active state until an external event occurs;
 	//this->sigma = Time::Zero; // force an internal transition in t=0;

 	// TODO: add init code here. (setting first state, etc)
 	
 	// set next transition

 	//holdIn( active, this->sigma  ) ;
 	totprojtime = 0;
 	totprojcost = 0;
 	totreqt = 0;
 	totdesignt = 0;
 	totimpt = 0;
 	this->passivate();
	return *this ;
}

/*******************************************************************
* Function Name: externalFunction
* Description: This method executes when an external event is received.
********************************************************************/
Model &Timecostcalculator::externalFunction( const ExternalMessage &msg )
{
	//[(!) update common variables]	

	this->sigma = nextChange();	
	this->elapsed = msg.time()-lastChange();	
 	this->timeLeft = this->sigma - this->elapsed; 


 	if(msg.port() == totalreqtime){
 		totreqt = msg.value();
 	}
 	if(msg.port() == totaldesigntime){
 		totdesignt = msg.value();
 	}
 	if(msg.port() == totalimptime){
 		totimpt = msg.value();
 	}

 	if ( this->state() == passive )
 	 {
 		totprojtime = totimpt + totdesignt + totreqt;
 		totprojcost = totprojtime * 100;
 		holdIn(active, preparationTime);
 	}
	
	return *this ;
}

/*******************************************************************
* Function Name: internalFunction
* Description: This method executes when the TA has expired, right after the outputFunction has finished.
* 			   The new state and TA should be set.
********************************************************************/
Model &Timecostcalculator::internalFunction( const InternalMessage & )
{
	//TODO: implement the internal function here
	if(totreqt != 0 && totdesignt != 0 && totimpt != 0){
	  totreqt = 0;
	  totdesignt = 0;
	  totimpt = 0;
	}
	totprojtime = 0;
	totprojcost = 0;
	this->sigma = Time::Inf; // stays in passive state until an external event occurs;
	holdIn( passive, this->sigma  );
	return *this;

}

/*******************************************************************
* Function Name: outputFunction
* Description: This method executes when the TA has expired. After this method the internalFunction is called.
*              Output values can be send through output ports
********************************************************************/
Model &Timecostcalculator::outputFunction( const InternalMessage &msg )
{
	//TODO: implement the output function here
	// remember you can use sendOutput(time, outputPort, value) function.
	if(totreqt != 0 && totdesignt != 0 && totimpt != 0){
	  sendOutput( msg.time(), totaltime , totprojtime ) ;
	  sendOutput( msg.time(), projectcost , totprojcost );
	}
	return *this;

}

Timecostcalculator::~Timecostcalculator()
{
	//TODO: add destruction code here. Free distribution memory, etc. 
}
